
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_BloodUnitTest : BaseTest 
	{
		
		private DataTable _dtBloodUnit;
		private DataTable _dtBloodUnitTest;
		private DataTable _dtSpecialUnitTest;
		private DataTable _dtRack;
		private DataTable _dtReagent;
		private DataTable _dtRackLot;
		private DataTable _dtRackTest;
		private DataTable _dtAntiseraWorklistTyping;
		private DataTable _dtBUTwOrderedTest;
		private DataTable _dtBUTwOrderedComponent;
		private DataTable _dtOrderedUnit;
		private DataTable _dtOrderedTest;
		private DataTable _dtOrderedComponent;
		private DataTable _dtNonLimitedUnits;
		private DataTable _dtLimitedUnits;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//***Get the Rack data
				this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				if (this._dtRack.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				}

				this._dtBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE TestDate IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", false);
				if (this._dtBloodUnitTest.Rows.Count == 0)
				{
                    BOL.BloodUnit tmpUnit = DataCreator.CreateRBCBloodUnit(true);
					DataCreator.CreateAboRhConfirmationTestsForUnit(tmpUnit.BloodUnitGuid, tmpUnit.BloodUnitMedia.AboRh);
					this._dtBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE TestDate IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);
				}

				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get BloodUnitTest data  -- With ABO to handle most calls
				this._dtBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE BloodTestTypeId > 14 AND BloodTestTypeId < 22 AND ConfirmationWorklistUnitGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get the SpecialUnitTest data
				string sql = "SELECT TOP 1 * FROM dbo.BloodUnitTest BUT INNER JOIN   dbo.BloodTestType BTT on BUT.BloodTestTypeID = BUT.BloodTestTypeID INNER JOIN dbo.BloodUnitAntigen BUA on BUA.BloodUnitGUID = BUT.BloodUnitGUID INNER JOIN dbo.AntigenType ATT on ATT.AntigenTypeID = BUA.AntigenTypeID WHERE BUT.DivisionCode = '" + this.TestDivisionCode + "' AND BUT.RecordStatusCode = 'A'";
				this._dtSpecialUnitTest = UnitTestUtil.RunSQLGetDataTable(sql, false);
				if (this._dtSpecialUnitTest.Rows.Count == 0)
				{
					Guid unitGuid = Guid.NewGuid();
					BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(unitGuid, Guid.NewGuid(), Guid.Empty, DataCreator.GetRandomBloodProduct(true, COMMON.ComponentClass.RBC).BloodProductGuid, true);
					DataCreator.CreateAboRhConfirmationTestsForUnit(unitGuid, tmpUnit.BloodUnitMedia.AboRh);
					DataTable dtBUA = SprocHelper.GetInsertBloodUnitAntigenSprocTable(unitGuid);
					new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertBloodUnitAntigen.StoredProcName, dtBUA);
					this._dtSpecialUnitTest = UnitTestUtil.RunSQLGetDataTable(sql, true);
				}

				//***Get the Reagent data
				this._dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Reagent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				if (this._dtReagent.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Reagent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , true);
				}

				//***Get the RackLot data
				this._dtRackLot = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackLot WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				if (this._dtReagent.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtRackLot = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackLot WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , true);
				}

				//***Get the RackTest data
				this._dtRackTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackTest WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				if (this._dtReagent.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtRackTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackTest WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , true);
				}

				//***Get the AntiseraWorklistTyping data
				this._dtAntiseraWorklistTyping = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 BUT.*, AWT.AntiseraWorklistGuid, AWT.OrderableTestId FROM BloodUnitTest BUT JOIN AntiseraWorklistTyping AWT ON AWT.AntiseraWorklistTypingGuid = BUT.AntiseraWorklistTypingGuid WHERE BUT.DivisionCode = '" + this.TestDivisionCode + "' AND BUT.RecordStatusCode = 'A'" , false);
				if (this._dtAntiseraWorklistTyping.Rows.Count == 0)
				{
					new BOL.UnitTests.BOL_AntiseraWorklist().Save_Pass_AntigenTyping();
					this._dtAntiseraWorklistTyping = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 BUT.*, AWT.AntiseraWorklistGuid, AWT.OrderableTestId FROM BloodUnitTest BUT JOIN AntiseraWorklistTyping AWT ON AWT.AntiseraWorklistTypingGuid = BUT.AntiseraWorklistTypingGuid WHERE BUT.DivisionCode = '" + this.TestDivisionCode + "' AND BUT.RecordStatusCode = 'A'" , true);
				}


				//***Get the BloodUnitTest with an OrderedTestGuid data
				this._dtBUTwOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest JOIN BloodTestType ON BloodTestType.BloodTestTypeID = BloodUnitTest.BloodTestTypeID JOIN OrderedUnit ON OrderedUnit.BloodUnitGuid = BloodUnitTest.BloodUnitGuid AND OrderedUnit.ReleaseDate IS NULL AND OrderedUnit.OrderedTestGuid IS NOT NULL WHERE BloodUnitTest.OrderedTestGuid IS NOT NULL AND BloodUnitTest.RecordStatusCode = 'A' AND BloodUnitTest.DivisionCode = '" + this.TestDivisionCode + "'", false);
				if (this._dtBUTwOrderedTest.Rows.Count == 0)
				{
					Guid buGuid = Guid.NewGuid();
					DataCreator.CreateBloodUnit(buGuid, Guid.NewGuid(), Guid.Empty, DataCreator.GetRandomBloodProduct(true, COMMON.ComponentClass.RBC).BloodProductGuid, true);

					DataCreator.CreatePatientAssignment(buGuid , Guid.NewGuid(), true,false );
					this._dtBUTwOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest JOIN BloodTestType ON BloodTestType.BloodTestTypeID = BloodUnitTest.BloodTestTypeID JOIN OrderedUnit ON OrderedUnit.BloodUnitGuid = BloodUnitTest.BloodUnitGuid AND OrderedUnit.ReleaseDate IS NULL AND OrderedUnit.OrderedTestGuid IS NOT NULL WHERE BloodUnitTest.OrderedTestGuid IS NOT NULL AND BloodUnitTest.RecordStatusCode = 'A' AND BloodUnitTest.DivisionCode = '" + this.TestDivisionCode + "'", true);
				}

				//***Get the BloodUnitTest with an OrderedComponentGuid data
				this._dtBUTwOrderedComponent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE OrderedComponentGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get the OrderedUnit info for InvalidateCrossMatchStatus
				this._dtOrderedUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get the OrderedTest info for InvalidateCrossMatchStatus
				this._dtOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedTest WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get the OrderedComponent info for InvalidateCrossMatchStatus
				this._dtOrderedComponent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);

				this._dtLimitedUnits = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND UnitStatusCode = 'L' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtLimitedUnits.Rows.Count == 0)
				{
					DataCreator.CreateRBCBloodUnit(true);
					this._dtLimitedUnits = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND UnitStatusCode = 'L' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}

				this._dtNonLimitedUnits = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND UnitStatusCode IN ('S','A','C') AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtNonLimitedUnits.Rows.Count == 0)
				{
					BOL.BloodUnit newUnit = DataCreator.CreateRBCBloodUnit(true);
					DataCreator.CreateAboRhConfirmationTestsForUnit(newUnit.BloodUnitGuid, newUnit.BloodUnitMedia.AboRh);
					DataCreator.CreateCrossmatchedBloodUnitTestData();
					this._dtNonLimitedUnits = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND UnitStatusCode IN ('S','A','C') AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}

				this.RefreshData = false;
			}

		}

		[Test]
		public void GetBloodUnitTestResult_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			int testId = (int)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId];
			
			DataTable dtTest = DAL.BloodUnitTest.GetBloodUnitTestResult(unitGuid, testId, Common.LogonUser.LogonUserDivisionCode);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(10, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryMethodCode), TABLES.BloodUnitTest.EntryMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
		}

		[Test]
		public void GetBloodUnitTestResult_Fail()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetBloodUnitTestResult(System.Guid.NewGuid(), int.MinValue, Common.LogonUser.LogonUserDivisionCode);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitSpecialTest_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtSpecialUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			
			DataTable dtTest = DAL.BloodUnitTest.GetBloodUnitSpecialTest(unitGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		public void GetBloodUnitSpecialTest_Fail()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetBloodUnitSpecialTest(System.Guid.NewGuid());

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitTestResults_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			
			//2899
			DataTable dtTest = DAL.BloodUnitTest.GetBloodUnitTestResults(unitGuid.ToString(), Common.LogonUser.LogonUserDivisionCode);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(21, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedTestGuid), TABLES.BloodUnitTest.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestingMethodCode), TABLES.BloodUnitTest.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryTechId), TABLES.BloodUnitTest.EntryTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.CorrectedResultIndicator), TABLES.BloodUnitTest.CorrectedResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.AntiseraWorklistTypingGuid), TABLES.BloodUnitTest.AntiseraWorklistTypingGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid), TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.InactivateDate), TABLES.BloodUnitTest.InactivateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryMethodCode), TABLES.BloodUnitTest.EntryMethodCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RecordStatusCode), TABLES.BloodUnitTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.AutoInstrumentName), TABLES.BloodUnitTest.AutoInstrumentName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RackGuid), TABLES.BloodUnitTest.RackGuid);

		}

		[Test]
		public void GetBloodUnitTestResults_Fail()
		{
			//2899
			DataTable dtTest = DAL.BloodUnitTest.GetBloodUnitTestResults(System.Guid.NewGuid().ToString(), Common.LogonUser.LogonUserDivisionCode);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAboRHConfirmationTests_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			
			DataTable dtTest = DAL.BloodUnitTest.GetAboRHConfirmationTests(unitGuid, Common.LogonUser.LogonUserDivisionCode);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid), TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryMethodCode), TABLES.BloodUnitTest.EntryMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
		}

		[Test]
		public void GetAboRHConfirmationTests_Fail()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetAboRHConfirmationTests(System.Guid.NewGuid(), Common.LogonUser.LogonUserDivisionCode);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAntigenTypingTests_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			
			DataTable dtTest = DAL.BloodUnitTest.GetAntigenTypingTests(unitGuid, Common.LogonUser.LogonUserDivisionCode);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(15, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.AntiseraWorklistTypingGuid), TABLES.BloodUnitTest.AntiseraWorklistTypingGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklistTyping.OrderableTestId), TABLES.AntiseraWorklistTyping.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestName), TABLES.OrderableTest.OrderableTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryMethodCode), TABLES.BloodUnitTest.EntryMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
		}

		[Test]
		public void GetAntigenTypingTests_Fail()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetAntigenTypingTests(System.Guid.NewGuid(), Common.LogonUser.LogonUserDivisionCode);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAboConfirmationLookup_Pass()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetAboConfirmationLookup();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AntiA), TABLES.ValidAboResult.AntiA);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AntiB), TABLES.ValidAboResult.AntiB);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AntiAB), TABLES.ValidAboResult.AntiAB);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AboInterp), TABLES.ValidAboResult.AboInterp);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AboInitial), TABLES.ValidAboResult.AboInitial);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAboConfirmationLookup_Fail()
		{
		}

		
		[Test]
		public void GetRHConfirmationLookup_Pass()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetRHConfirmationLookup();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidRhResult.AntiD), TABLES.ValidRhResult.AntiD);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidRhResult.DControl), TABLES.ValidRhResult.DControl);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidRhResult.RhInterp), TABLES.ValidRhResult.RhInterp);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidRhResult.RhInitial), TABLES.ValidRhResult.RhInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidRhResult.SystemInterp), TABLES.ValidRhResult.SystemInterp);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRHConfirmationLookup_Fail()
		{
		}

		[Test]
		public void SaveAboRHBloodUnitTests_Pass()
		{
			this.RefreshData = true;
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			DataTable dtException = new DataTable();

			System.Guid[] workloadGuids = {(System.Guid)this._dtLimitedUnits.Rows[0][TABLES.BloodUnit.BloodUnitGuid]};
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ABORhForwardTypingUnit);
			DataTable dtWorkload = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.ABORhForwardTypingUnit, workloadGuids, Common.WorkloadTransactionType.Unit, false);

			DataTable dtUnitTests = this.GetBloodUnitTests(this._dtLimitedUnits.Rows[0][TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode].ToString());

			DAL.BloodUnitTest.SaveAboRHBloodUnitTests(dtUnitTests, dtException, dtWorkload, System.DateTime.Now, Common.LogonUser.LogonUserName, "Plop", true, rackGuid, Common.LogonUser.LogonUserDivisionCode, Common.UpdateFunction.UnitTests, null);

			//No return value, so a crash is a fail
			Assert.AreEqual(true, true, "Limited UnitStatusCode, 'V'alid");
		}

		[Test]
		public void SaveAboRHBloodUnitTests_Pass2()
		{
			this.RefreshData = true;

			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			DataTable dtExceptionAboRh = new DataTable();
			DataTable dtExceptionQc = new DataTable();
			DataTable dtWorkload = new DataTable();

			DataTable dtUnitTests = this.GetBloodUnitTests(this._dtLimitedUnits.Rows[0][TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode].ToString());
			BOL.BloodUnit tmpUnit = new BOL.BloodUnit((System.Guid)dtUnitTests.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);

			BOL.ExceptionReport aboRhEx = new BOL.ExceptionReport(Common.ExceptionType.ABORh_confirmation_does_not_match_login_ABORh, "UnitTest-SaveAboRHBloodUnitTests_Pass2", Common.LogonUser.LogonUserName);
			aboRhEx.GenerateExceptionUnitAboRh(tmpUnit.BloodUnitGuid, "I", "I", "Test User1");
			dtExceptionAboRh = aboRhEx.ExceptionData.Table.Clone();
			dtExceptionAboRh.Rows.Add(aboRhEx.ExceptionData.ItemArray);

			BOL.ExceptionReport exQc = new BOL.ExceptionReport(Common.ExceptionType.QC_not_performed_on_rack_used_for_testing, "UnitTest-SaveAboRHBloodUnitTests_Pass2", Common.LogonUser.LogonUserName);
			exQc.GenerateExceptionQCNotPerformed(tmpUnit.EyeReadableUnitId, tmpUnit.FullProductCode, "Racky", Common.LogonUser.LogonUserName);
			dtExceptionQc = exQc.ExceptionData.Table.Clone();
			dtExceptionQc.Rows.Add(exQc.ExceptionData.ItemArray);

			// This is necessary to make sure that all lines of code within the method are hit.
			dtUnitTests.Rows[0][ARTIFICIAL.Indicator]="W";

			DAL.BloodUnitTest.SaveAboRHBloodUnitTests(dtUnitTests, dtExceptionAboRh, dtWorkload, System.DateTime.Now, Common.LogonUser.LogonUserName, "Plop", true, rackGuid, Common.LogonUser.LogonUserDivisionCode, Common.UpdateFunction.UnitTests, dtExceptionQc);

			//No return value, so a crash is a fail
			Assert.AreEqual(true, true, "Limited UnitStatusCode, 'W'arning");
		}

		[Test]
		public void SaveAboRHBloodUnitTests_Pass3()
		{
			//Tests non Limited Unit Status of testing unit
			this.RefreshData = true;

			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			DataTable dtException = new DataTable();
			DataTable dtWorkload = new DataTable();

			DataTable dtUnitTests = this.GetBloodUnitTests(this._dtNonLimitedUnits.Rows[0][TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode].ToString());

			dtUnitTests.Rows[0][TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode] = this._dtNonLimitedUnits.Rows[0][TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode];
			dtUnitTests.Rows[0][TABLES.BloodUnit.EyeReadableUnitId] = this._dtNonLimitedUnits.Rows[0][TABLES.BloodUnit.EyeReadableUnitId];
			dtUnitTests.Rows[0][TABLES.BloodUnit.BloodUnitGuid] = (System.Guid)this._dtNonLimitedUnits.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			dtUnitTests.Rows[0][TABLES.BloodUnit.RowVersion] = (byte[])this._dtNonLimitedUnits.Rows[0][ARTIFICIAL.UnitStatusRowVersion];

			DAL.BloodUnitTest.SaveAboRHBloodUnitTests(dtUnitTests, dtException, dtWorkload, System.DateTime.Now, Common.LogonUser.LogonUserName, "Plop", true, rackGuid, Common.LogonUser.LogonUserDivisionCode, Common.UpdateFunction.UnitTests, dtException);

			//No return value, so a crash is a fail
			Assert.AreEqual(true, true, "Non-Limited UnitStatusCode, 'V'alid");
		}

		[Test]
		public void SaveAboRHBloodUnitTests_Pass4()
		{
			//Tests non Limited Unit Status of testing unit
			this.RefreshData = true;

			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			DataTable dtExceptionAboRh = new DataTable();
			DataTable dtExceptionQc = new DataTable();
			DataTable dtWorkload = new DataTable();

			DataTable dtUnitTests = this.GetBloodUnitTests(this._dtNonLimitedUnits.Rows[0][TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode].ToString());
			BOL.BloodUnit tmpUnit = new BOL.BloodUnit((System.Guid)dtUnitTests.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);

			BOL.ExceptionReport aboRhEx = new BOL.ExceptionReport(Common.ExceptionType.ABORh_confirmation_does_not_match_login_ABORh, "UnitTest-SaveAboRHBloodUnitTests_Pass2", Common.LogonUser.LogonUserName);
			aboRhEx.GenerateExceptionUnitAboRh(tmpUnit.BloodUnitGuid, "I", "I", "Test User1");
			dtExceptionAboRh = aboRhEx.ExceptionData.Table.Clone();
			dtExceptionAboRh.Rows.Add(aboRhEx.ExceptionData.ItemArray);

			BOL.ExceptionReport exQc = new BOL.ExceptionReport(Common.ExceptionType.QC_not_performed_on_rack_used_for_testing, "UnitTest-SaveAboRHBloodUnitTests_Pass2", Common.LogonUser.LogonUserName);
			exQc.GenerateExceptionQCNotPerformed(tmpUnit.EyeReadableUnitId, tmpUnit.FullProductCode, "Racky", Common.LogonUser.LogonUserName);
			dtExceptionQc = exQc.ExceptionData.Table.Clone();
			dtExceptionQc.Rows.Add(exQc.ExceptionData.ItemArray);

			// This is necessary to make sure that all lines of code within the method are hit.
			dtUnitTests.Rows[0][ARTIFICIAL.Indicator]="W";

			dtUnitTests.Rows[0][TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode] = this._dtNonLimitedUnits.Rows[0][TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode];
			dtUnitTests.Rows[0][TABLES.BloodUnit.EyeReadableUnitId] = this._dtNonLimitedUnits.Rows[0][TABLES.BloodUnit.EyeReadableUnitId];
			dtUnitTests.Rows[0][TABLES.BloodUnit.BloodUnitGuid] = (System.Guid)this._dtNonLimitedUnits.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			dtUnitTests.Rows[0][TABLES.BloodUnit.RowVersion] = (byte[])this._dtNonLimitedUnits.Rows[0][ARTIFICIAL.UnitStatusRowVersion];

			DAL.BloodUnitTest.SaveAboRHBloodUnitTests(dtUnitTests, dtExceptionAboRh, dtWorkload, System.DateTime.Now, Common.LogonUser.LogonUserName, "Plop", true, rackGuid, Common.LogonUser.LogonUserDivisionCode, Common.UpdateFunction.UnitTests, dtExceptionQc);

			//No return value, so a crash is a fail
			Assert.AreEqual(true, true, "Non-Limited UnitStatusCode, 'W'arning");
		}

		[Test]
		public void SaveAboRHBloodUnitTests_Pass5()
		{
			this.RefreshData = true;
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			DataTable dtException = new DataTable();
			DataTable dtWorkload = new DataTable();

			DataTable dtUnitTests = this.GetBloodUnitTests(this._dtLimitedUnits.Rows[0][TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode].ToString());

			DAL.BloodUnitTest.SaveAboRHBloodUnitTests(dtUnitTests, dtException, dtWorkload, System.DateTime.Now, Common.LogonUser.LogonUserName, "Plop", true, rackGuid, Common.LogonUser.LogonUserDivisionCode, Common.UpdateFunction.UnitTests, dtException);

			//No return value, so a crash is a fail
			Assert.AreEqual(true, true, "Limited UnitStatusCode, 'V'alid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SaveAboRHBloodUnitTests_Fail()
		{
			//Code pulls in the latest data - no way to fail method
		}

		[Test]
		public void GetEmptyBloodUnitTestTableSchema_Pass()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetEmptyBloodUnitTestTableSchema(true);

			Assert.AreEqual(TABLES.BloodUnitTest.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(18, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);	
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId ), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryMethodCode), TABLES.BloodUnitTest.EntryMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.LastUpdateUser), TABLES.BloodUnitTest.LastUpdateUser);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.LastUpdateFunctionId), TABLES.BloodUnitTest.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid), TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryTechId), TABLES.BloodUnitTest.EntryTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestingMethodCode), TABLES.BloodUnitTest.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RackGuid), TABLES.BloodUnitTest.RackGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.AutoInstrumentName), TABLES.BloodUnitTest.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RecordStatusCode), TABLES.BloodUnitTest.RecordStatusCode);
			
		}

		[Test]
		public void GetEmptyBloodUnitTestTableSchema_Fail()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetEmptyBloodUnitTestTableSchema(false);

			Assert.AreEqual(TABLES.BloodUnitTest.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);	
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId ), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryMethodCode), TABLES.BloodUnitTest.EntryMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.LastUpdateUser), TABLES.BloodUnitTest.LastUpdateUser);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.LastUpdateFunctionId), TABLES.BloodUnitTest.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid), TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryTechId), TABLES.BloodUnitTest.EntryTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestingMethodCode), TABLES.BloodUnitTest.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RackGuid), TABLES.BloodUnitTest.RackGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.AutoInstrumentName), TABLES.BloodUnitTest.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RecordStatusCode), TABLES.BloodUnitTest.RecordStatusCode);
		}


		[Test]
		public void SaveBloodUnitTest_Pass()
		{
			this.RefreshData = true;

			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			int testTypeId = (int)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId];
			string resultId = this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.TestResultId].ToString();
			string comments = System.DateTime.Now.ToString();

			DAL.BloodUnitTest.SaveBloodUnitTest(unitGuid, testTypeId, resultId, "M", comments, UnitTestConfig.TestDivisionCode,  Common.UpdateFunction.UnitTests, System.Guid.Empty);

			Assert.AreEqual(true, true, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void SaveBloodUnitTest_Fail()
		{
			System.Guid unitGuid = System.Guid.NewGuid();
			int testTypeId = int.MinValue;
			string resultId = string.Empty;
			string comments = System.DateTime.Now.ToString();

			DAL.BloodUnitTest.SaveBloodUnitTest(unitGuid, testTypeId, resultId, "M", comments, UnitTestConfig.TestDivisionCode,  Common.UpdateFunction.UnitTests, System.Guid.Empty);
		}

		
		[Test]
		public void GetEmptyAboRhConfirmationTable_Pass()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetEmptyAboRhConfirmationTable();
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(23, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.Indicator), ARTIFICIAL.Indicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AntiA), TABLES.ValidAboResult.AntiA);	
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AntiB ), TABLES.ValidAboResult.AntiB);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AntiAB), TABLES.ValidAboResult.AntiAB);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidRhResult.AntiD), TABLES.ValidRhResult.AntiD);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidRhResult.DControl), TABLES.ValidRhResult.DControl);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AboInterp), TABLES.ValidAboResult.AboInterp);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidRhResult.RhInterp), TABLES.ValidRhResult.RhInterp);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.AboComment), ARTIFICIAL.AboComment);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.RhComment), ARTIFICIAL.RhComment);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidAboResult.AboInitial), TABLES.ValidAboResult.AboInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ValidRhResult.RhInitial), TABLES.ValidRhResult.RhInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.IndicatorMessage), ARTIFICIAL.IndicatorMessage);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.RowVersion), TABLES.BloodUnitStatus.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.BR217), ARTIFICIAL.BR217);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.BR221), ARTIFICIAL.BR221);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.BR207), ARTIFICIAL.BR207);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductCode), TABLES.BloodProduct.ProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyAboRhConfirmationTable_Fail()
		{
		}

		
		[Test]
		public void UpdateTestResult_Pass()
		{
			this.RefreshData = true;

			System.Guid testGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			string resultId = this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.TestResultId].ToString();
			DateTime testDate = Convert.ToDateTime(this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.TestDate]);
			string testTechId = this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.TestTechId].ToString();
			byte[] rowVersion = (byte[])this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.RowVersion];

			DAL.BloodUnitTest.UpdateTestResult(testGuid, resultId, testDate, testTechId, rowVersion, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, true, "RetunValue");
		}

		
		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateTestResult_Fail()
		{
			System.Guid testGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			string resultId = this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.TestResultId].ToString();
			DateTime testDate = Convert.ToDateTime(this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.TestDate]);
			string testTechId = this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.TestTechId].ToString();
			byte[] rowVersion = new byte[8];

			DAL.BloodUnitTest.UpdateTestResult(testGuid, resultId, testDate, testTechId, rowVersion, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void SaveAntigenTypingBloodUnitTests_Pass()
		{
			this.RefreshData = true;
			
			System.Guid reagentGuid =  (System.Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			System.Guid rackGuid =  (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			
			DataTable dtWorkload = null;	//We don't care about workload
			DataTable dtException = null;	//We don't care about exceptions

			System.Guid butGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			byte[] rowVersion = (byte[])this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.RowVersion];
			DataTable dtUResult = SprocHelper.GetUpdateBloodUnitTestResultSprocTable(butGuid, rowVersion);
			
			DataTable dtIRackLot = SprocHelper.GetInsertRackLotSprocTable(reagentGuid, rackGuid);

			System.Guid rlGuid = (System.Guid)this._dtRackLot.Rows[0][TABLES.RackLot.RackLotGuid];
			System.Guid rlReagentGuid = (System.Guid)this._dtRackLot.Rows[0][TABLES.RackLot.ReagentGuid];
			byte[] rlRowVersion = (byte[])this._dtRackLot.Rows[0][TABLES.RackLot.RowVersion];
			DataTable dtURackLot = SprocHelper.GetUpdateRackLotSprocTable(rlGuid, rlReagentGuid, rlRowVersion);
			
			System.Guid rtGuid = (System.Guid)this._dtRackTest.Rows[0][TABLES.RackTest.RackTestGuid];
			byte[] rtRowVersion = (byte[])this._dtRackTest.Rows[0][TABLES.RackTest.RowVersion];
			DataTable dtURackTest = SprocHelper.GetUpdateRackTestSprocTable(rtGuid, rtRowVersion);
			dtURackTest.Rows[0][TABLES.RackTest.RackTestResult] = this._dtRackTest.Rows[0][TABLES.RackTest.RackTestResult];
			dtURackTest.Rows[0][TABLES.RackTest.TestDate] = this._dtRackTest.Rows[0][TABLES.RackTest.TestDate];
			dtURackTest.Rows[0][TABLES.RackTest.TestTechId] = Common.LogonUser.LogonUserName;
			dtURackTest.Rows[0][TABLES.RackTest.DivisionCode] = this._dtRackTest.Rows[0][TABLES.RackTest.DivisionCode];

			DataTable dtIAntisera = SprocHelper.GetInsertAntiseraUnitTestSprocTable(System.Guid.NewGuid(), rlGuid);
			dtIAntisera.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid];

			bool retValue = DAL.BloodUnitTest.SaveAntigenTypingBloodUnitTests(dtWorkload, dtUResult, dtURackTest,dtIRackLot, dtURackLot, dtIAntisera, dtException, dtException, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "RetunValue");
		}

		
		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveAntigenTypingBloodUnitTests_Fail()
		{
			System.Guid reagentGuid =  (System.Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			System.Guid rackGuid =  (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			
			//No RowVersions being set to fail the condition
			DataTable dtWorkload = null;	//We don't care about workload
			DataTable dtException = null;	//We don't care about exceptions

			System.Guid butGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			byte[] rowVersion = new byte[8];
			DataTable dtUResult = SprocHelper.GetUpdateBloodUnitTestResultSprocTable(butGuid, rowVersion);
			
			DataTable dtIRackLot = SprocHelper.GetInsertRackLotSprocTable(reagentGuid, rackGuid);

			System.Guid rlGuid = (System.Guid)this._dtRackLot.Rows[0][TABLES.RackLot.RackLotGuid];
			System.Guid rlReagentGuid = (System.Guid)this._dtRackLot.Rows[0][TABLES.RackLot.ReagentGuid];
			DataTable dtURackLot = SprocHelper.GetUpdateRackLotSprocTable(rlGuid, rlReagentGuid, new byte[8]);
			
			System.Guid rtGuid = (System.Guid)this._dtRackTest.Rows[0][TABLES.RackTest.RackTestGuid];
			DataTable dtURackTest = SprocHelper.GetUpdateRackTestSprocTable(rtGuid, new byte[8]);
			dtURackTest.Rows[0][TABLES.RackTest.RackTestResult] = this._dtRackTest.Rows[0][TABLES.RackTest.RackTestResult];

			DataTable dtIAntisera = SprocHelper.GetInsertAntiseraUnitTestSprocTable(System.Guid.NewGuid(), rlGuid);
			dtIAntisera.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid];

			bool retValue = DAL.BloodUnitTest.SaveAntigenTypingBloodUnitTests(dtWorkload, dtUResult, dtURackTest,dtIRackLot, dtURackLot, dtIAntisera, dtException, dtException, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void SaveWeakDBloodUnitTests_Pass()
		{
			this.RefreshData = true;

			//No RowVersions being set to fail the condition
			DataTable dtWorkload = new DataTable();
			DataTable dtExceptions = null;
			System.Guid butGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			byte[] rowVersion = (byte[])this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.RowVersion];
			DataTable dtUResult = SprocHelper.GetUpdateBloodUnitTestResultSprocTable(butGuid, rowVersion);
						
			bool retValue = DAL.BloodUnitTest.SaveWeakDBloodUnitTests(dtUResult, dtWorkload, dtExceptions, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "RetunValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveWeakDBloodUnitTests_Fail()
		{
			//No RowVersions being set to fail the condition
			DataTable dtWorkload = new DataTable();
			DataTable dtExceptions = null;
			System.Guid butGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			byte[] rowVersion = new byte[8];
			DataTable dtUResult = SprocHelper.GetUpdateBloodUnitTestResultSprocTable(butGuid, rowVersion);
						
			bool retValue = DAL.BloodUnitTest.SaveWeakDBloodUnitTests(dtUResult, dtWorkload, dtExceptions, Common.UpdateFunction.UnitTests);

		}

		[Test]
		public void GetTestResultsForXM_Pass()
		{
			System.Guid orderedComponentGuid = (System.Guid)this._dtBUTwOrderedComponent.Rows[0][TABLES.BloodUnitTest.OrderedComponentGuid];
			System.Guid orderedTestGuid = (System.Guid)this._dtBUTwOrderedTest.Rows[0][TABLES.BloodUnitTest.OrderedTestGuid];

			DataTable dtTest = DAL.BloodUnitTest.GetTestResultsForXM(orderedTestGuid, System.Guid.Empty);
			
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows1.Count");
			Assert.AreEqual(13, dtTest.Columns.Count, "Columns1.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), "1-" + TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), "1-" + TABLES.BloodUnitTest.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), "1-" + TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), "1-" + TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.CorrectedResultIndicator), "1-" + TABLES.BloodUnitTest.CorrectedResultIndicator);

			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), "1-" + TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), "1-" + TABLES.BloodUnitTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), "1-" + TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.ReactivityPhaseCode), "1-" + TABLES.BloodUnitTest.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid), "1-" + TABLES.OrderedUnit.OrderedUnitGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RackGuid), "1-" + TABLES.BloodUnitTest.RackGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedComponentGuid), "1-" + TABLES.BloodUnitTest.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedTestGuid), "1-" + TABLES.BloodUnitTest.OrderedTestGuid);

			dtTest = DAL.BloodUnitTest.GetTestResultsForXM(System.Guid.Empty, orderedComponentGuid);
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows2.Count");
			Assert.AreEqual(14, dtTest.Columns.Count, "Columns2.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), "2-" + TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), "2-" + TABLES.BloodUnitTest.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), "2-" + TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), "2-" + TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.CorrectedResultIndicator), "2-" + TABLES.BloodUnitTest.CorrectedResultIndicator);

			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), "2-" + TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), "2-" + TABLES.BloodUnitTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), "2-" + TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.ReactivityPhaseCode), "2-" + TABLES.BloodUnitTest.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid), "2-" + TABLES.OrderedUnit.OrderedUnitGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.ReleaseDate), "2-" + TABLES.OrderedUnit.ReleaseDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RackGuid), "2-" + TABLES.BloodUnitTest.RackGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedComponentGuid), "2-" + TABLES.BloodUnitTest.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedTestGuid), "2-" + TABLES.BloodUnitTest.OrderedTestGuid);
		}

		[Test]
		public void GetTestResultsForXM_Fail()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetTestResultsForXM(System.Guid.NewGuid(), System.Guid.NewGuid());
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void InactivateAboRHConfirmationTests_Pass()
		{
			this.RefreshData = true;

			System.Guid unitGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			DataTable dtWorkload = new DataTable();
			System.Guid worklistGuid = (System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid];
			string comments = System.DateTime.Now.ToString();

			// Added 12/6/2004 RDH
			byte[] rowVersion = (byte[])this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.RowVersion];
			
			// Added 12/6/2004 RDH
			DataTable dtTests = SprocHelper.GetInactivateABORHConfirmationTestsSprocTable(unitGuid,worklistGuid,comments,rowVersion);

			DAL.BloodUnitTest.InactivateAboRHConfirmationTests( dtTests, dtWorkload );			
			
			//Set the data back
			int retValue = UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET TestComments = 'Excellent', RecordStatusCode = 'A', InactivateDate = null, InactivateUser = null WHERE TestComments = '" + comments + "'");

			//No return value, so assume success
			Assert.AreEqual(true, true, "ReturnValue");
		}
		
		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void InactivateAboRHConfirmationTests_Fail()
		{
			System.Guid unitGuid = System.Guid.NewGuid();
			DataTable dtWorkload = new DataTable();
			System.Guid worklistGuid = System.Guid.NewGuid();
			string comments = "KABOOM!";			

			// Added 12/6/2004 RDH
			byte[] rowVersion=new byte[0];
			
			// Added 12/6/2004 RDH
			DataTable dtTests = SprocHelper.GetInactivateABORHConfirmationTestsSprocTable(unitGuid,worklistGuid,comments,rowVersion);

			DAL.BloodUnitTest.InactivateAboRHConfirmationTests( dtTests, dtWorkload );
		}

		[Test]
		public void InactivateAntigenTypingTests_Pass()
		{
			this.RefreshData = true;

			System.Guid unitGuid = (System.Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			DataTable dtWorkload = new DataTable();
			System.Guid worklistTypingGuid = (System.Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.BloodUnitTest.AntiseraWorklistTypingGuid];
			int testId = (int)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.OrderableTestId];
			byte[] rowVersion = (byte[])this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.RowVersion];
			string comments = System.DateTime.Now.ToString();

			DataTable dtAntigenTests = SprocHelper.GetInactivateAntigenTypingTestsSprocTable(unitGuid,worklistTypingGuid,testId,comments,rowVersion);

			DAL.BloodUnitTest.InactivateAntigenTypingTests(dtAntigenTests, dtWorkload, Common.UpdateFunction.UnitTests);
			
			//Set the data back
			int uCheck = UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET TestComments = 'Excellent', RecordStatusCode = 'A', InactivateDate = null, InactivateUser = null WHERE TestComments = '" + comments + "'");

			//No return value, so assume success
			Assert.AreEqual(true, true, "ReturnValue");
		}
		
		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void InactivateAntigenTypingTests_Fail()
		{

			System.Guid unitGuid = System.Guid.NewGuid();
			DataTable dtWorkload = new DataTable();
			System.Guid worklistTypingGuid = System.Guid.NewGuid();
			int testId = int.MinValue;
			string comments = "KABOOM!";
			byte[] rowVersion=new byte[0];

			DataTable dtAntigenTests = SprocHelper.GetInactivateAntigenTypingTestsSprocTable(unitGuid,worklistTypingGuid,testId,comments,rowVersion);

			DAL.BloodUnitTest.InactivateAntigenTypingTests(dtAntigenTests, dtWorkload, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void InvalidateCrossmatchTestResults_Pass()
		{
			this.RefreshData = true;

			System.Guid componentGuid = (System.Guid)this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];
			byte[] componentRowVersion = (byte[])this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.RowVersion];

			System.Guid orderedTestGuid = (System.Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.OrderedTestGuid];
			byte[] otRowVersion = (byte[])this._dtOrderedTest.Rows[0][TABLES.OrderedTest.RowVersion];

			DataTable dtResults = SprocHelper.GetUpdateCrossmatchTestStatusSprocTable();
			dtResults.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid] = this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			dtResults.Rows[0][TABLES.BloodUnitTest.RowVersion] = this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.RowVersion];

			System.Guid ouGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.OrderedUnitGuid];
			byte[] ouRowVersion = (byte[])this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.RowVersion];
			DataTable dtOUnit = SprocHelper.GetUpdateOrderedUnitSprocTable(ouGuid, ouRowVersion);

			DataTable dtOTest = SprocHelper.GetUpdateOrderedTestStatusSprocTable(orderedTestGuid, otRowVersion);

			DataTable dtOComponent = SprocHelper.GetUpdateOrderedComponentStatusSprocTable(componentGuid, componentRowVersion);

			System.Guid[] workloadGuids = {(System.Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnit.BloodUnitGuid]};
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.CrossmatchUnitElectronic);
			DataTable dtWorkload = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.CrossmatchUnitElectronic, 1, orderedTestGuid, componentGuid, workloadGuids, Common.WorkloadTransactionType.Unit, false);

			bool retValue = DAL.BloodUnitTest.InvalidateCrossmatchTestResults(dtResults, dtOUnit, dtOTest, dtOComponent, dtWorkload, Common.UpdateFunction.UnitTests);
			
			//Backtrack the important changes
			if (retValue)
			{
				int uCheck = UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET InactivateDate = null, InactivateUser = null WHERE BloodUnitTestGuid = '" + dtResults.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid].ToString() + "'");
			}

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		public void InvalidateCrossmatchTestResults_Fail()
		{
			DataTable dtResults = SprocHelper.GetUpdateCrossmatchTestStatusSprocTable();
			DataTable dtOUnit = SprocHelper.GetUpdateOrderedUnitSprocTable(System.Guid.NewGuid(), new byte[8]);
			DataTable dtOTest = SprocHelper.GetUpdateOrderedTestStatusSprocTable(System.Guid.NewGuid(), new byte[8]);
			DataTable dtOComponent = SprocHelper.GetUpdateOrderedComponentStatusSprocTable(System.Guid.NewGuid(), new byte[8]);

			try
			{
				dtResults.Columns.RemoveAt(0);
				DAL.BloodUnitTest.InvalidateCrossmatchTestResults(dtResults, dtOUnit, dtOTest, dtOComponent, new DataTable(),Common.UpdateFunction.UnitTests);
				Assert.AreEqual(true,false, "No Results");
			}
			catch(ArgumentException)
			{
				dtResults = SprocHelper.GetUpdateCrossmatchTestStatusSprocTable();
				Assert.AreEqual(true, true, "No Results");
			}
			try
			{
				dtOUnit.Columns.RemoveAt(0);
				DAL.BloodUnitTest.InvalidateCrossmatchTestResults(dtResults, dtOUnit, dtOTest, dtOComponent, new DataTable(),Common.UpdateFunction.UnitTests);
				Assert.AreEqual(true, false, "No OrderedUnit");
			}
			catch(ArgumentException)
			{
				dtOUnit = SprocHelper.GetUpdateOrderedUnitSprocTable(System.Guid.NewGuid(), new byte[8]);
				Assert.AreEqual(true, true, "No OrderedUnit");
			}
			try
			{
				dtOTest.Columns.RemoveAt(0);
				DAL.BloodUnitTest.InvalidateCrossmatchTestResults(dtResults, dtOUnit, dtOTest, dtOComponent, new DataTable(),Common.UpdateFunction.UnitTests);
				Assert.AreEqual(true, false, "No OrderedTest");
			}
			catch(ArgumentException)
			{
				dtOTest = SprocHelper.GetUpdateOrderedTestStatusSprocTable(System.Guid.NewGuid(), new byte[8]);
				Assert.AreEqual(true, true, "No OrderedTest");
			}
			try
			{
				dtOComponent.Columns.RemoveAt(0);
				DAL.BloodUnitTest.InvalidateCrossmatchTestResults(dtResults, dtOUnit, dtOTest, dtOComponent, new DataTable(),Common.UpdateFunction.UnitTests);
				Assert.AreEqual(true, false, "No OrderedComponent");
			}
			catch(ArgumentException)
			{
				Assert.AreEqual(true, true, "No OrderedComponent");
			}
		}

		[Test]
		public void GetBloodUnitTestOrder_Pass()
		{
			System.Guid unitTestGuid = (System.Guid)this._dtBUTwOrderedComponent.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			DataTable dtTest = DAL.BloodUnitTest.GetBloodUnitTestOrder(unitTestGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "1 -Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "1 -Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedComponentGuid), "1-" + TABLES.BloodUnitTest.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.PatientSpecimenGuid), "1-" + TABLES.OrderedTest.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.OrderStatusCode), "1-" + TABLES.OrderedTest.OrderStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.TaskStatusCode), "1-" + TABLES.OrderedTest.TaskStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.CancellationCannedCommentGuid), "1-" + TABLES.OrderedTest.CancellationCannedCommentGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.InappropriateRequestIndicator), "1-" + TABLES.OrderedComponent.InappropriateRequestIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.RowVersion), "1-" + TABLES.OrderedTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.EmergencyOrderIndicator), "1-" + TABLES.OrderedComponent.EmergencyOrderIndicator);

			////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			unitTestGuid = (System.Guid)this._dtBUTwOrderedTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			dtTest = DAL.BloodUnitTest.GetBloodUnitTestOrder(unitTestGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "2 -Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "2 -Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedTestGuid), "2-" + TABLES.BloodUnitTest.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.PatientSpecimenGuid), "2-" + TABLES.OrderedTest.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.OrderStatusCode), "2-" + TABLES.OrderedTest.OrderStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.TaskStatusCode), "2-" + TABLES.OrderedTest.TaskStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.CancellationCannedCommentGuid), "2-" + TABLES.OrderedTest.CancellationCannedCommentGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.InappropriateRequestIndicator), "2-" + TABLES.OrderedComponent.InappropriateRequestIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.RowVersion), "2-" + TABLES.OrderedTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.EmergencyOrderIndicator), "2-" + TABLES.OrderedComponent.EmergencyOrderIndicator);
		}

		[Test]
		public void GetBloodUnitTestOrder_Fail()
		{
			DataTable dtTest = DAL.BloodUnitTest.GetBloodUnitTestOrder(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void InvalidatePartiallyCompletedCrossmatch_Pass()
		{
			this.RefreshData = true;

			DataTable dtTest = new DataTable(TABLES.BloodUnitTest.TableName);

			dtTest.Columns.Add(TABLES.BloodUnitTest.BloodUnitTestGuid, typeof(System.Guid));
			dtTest.Columns.Add(TABLES.BloodUnitTest.InactivateDate, typeof(System.DateTime));
			dtTest.Columns.Add(TABLES.BloodUnitTest.InactivateUser, typeof(string));
			dtTest.Columns.Add(TABLES.BloodUnitTest.TestComments, typeof(string));
			dtTest.Columns.Add(TABLES.BloodUnitTest.RowVersion, typeof(byte[]));

			DataRow drAdd = dtTest.NewRow();
			drAdd[TABLES.BloodUnitTest.BloodUnitTestGuid] = this._dtBUTwOrderedTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];

			drAdd[TABLES.BloodUnitTest.InactivateDate] = System.DateTime.Now;
			drAdd[TABLES.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
			drAdd[TABLES.BloodUnitTest.TestComments] = "InvalidatePartiallyCompletedCrossmatch_Pass";

			drAdd[TABLES.BloodUnitTest.RowVersion] = this._dtBUTwOrderedTest.Rows[0][TABLES.BloodUnitTest.RowVersion];
			dtTest.Rows.Add(drAdd);

			Common.Utility.AppendLastUpdateInformation(dtTest, Common.UpdateFunction.UnitTests);

			bool retValue = DAL.BloodUnitTest.InvalidatePartiallyCompletedCrossmatch(dtTest);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InvalidatePartiallyCompletedCrossmatch_Fail()
		{
		}


		/// <summary>
		/// Create a blank DataTable that will mimic the table being sent from UC2
		/// </summary>
		/// <returns></returns>
		private DataTable GetBloodUnitTests(string unitStatusCode)
		{
			DataTable dtTests = DAL.BloodUnitTest.GetEmptyAboRhConfirmationTable();

			DataRow dr = dtTests.NewRow();
			dr[ARTIFICIAL.Indicator] = "V";
			dr[TABLES.ValidRhResult.RhInterp] = "N";
			dr[ARTIFICIAL.RhComment] = "Oops";
			dr[TABLES.ValidAboResult.AboInterp] = "A";
			dr[ARTIFICIAL.AboComment] = "Oops Again";
			dr[TABLES.ValidAboResult.AntiA] = "1";
			dr[TABLES.ValidAboResult.AntiB] = "1";
			dr[TABLES.ValidAboResult.AntiAB] = "1";
			dr[TABLES.ValidRhResult.AntiD] = "1";
			dr[TABLES.ValidRhResult.DControl] = "1";
			dr[TABLES.BloodUnit.BloodUnitGuid] = (System.Guid)this._dtLimitedUnits.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			dr[TABLES.BloodUnit.EyeReadableUnitId] = this._dtLimitedUnits.Rows[0][TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodUnit.RowVersion] = (byte[])this._dtLimitedUnits.Rows[0][ARTIFICIAL.UnitStatusRowVersion];
			dr[TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode] = unitStatusCode;
			dtTests.Rows.Add(dr);

			return(dtTests);
		}

	}
}


#endif



